import React, { useState } from 'react';
import LoginPage from './pages/LoginPage.jsx';
import InboxPage from './pages/InboxPage.jsx';

function App() {
  const [auth, setAuth] = useState(() => {
    const token = localStorage.getItem('token');
    const user = localStorage.getItem('user');
    if (token && user) {
      return { token, user: JSON.parse(user) };
    }
    return null;
  });

  if (!auth) {
    return <LoginPage onLogin={setAuth} />;
  }

  return (
    <InboxPage
      auth={auth}
      onLogout={() => {
        localStorage.removeItem('token');
        localStorage.removeItem('user');
        setAuth(null);
      }}
    />
  );
}

export default App;
