<?php
// salvar_simulacao.php
// Registra no banco o histórico de simulações realizadas pelo usuário logado.

require __DIR__ . '/db.php';
require __DIR__ . '/functions.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

header('Content-Type: application/json; charset=utf-8');

if (empty($_SESSION['usuario_autorizado']) || empty($_SESSION['usuario_email'])) {
    http_response_code(401);
    echo json_encode(['ok' => false, 'msg' => 'Usuário não autenticado.']);
    exit;
}

$usuarioEmail = $_SESSION['usuario_email'];

try {
    // Números já vêm em formato com ponto (enviados pelo JS), então basta converter para float.
    $cmv                  = isset($_POST['cmv']) ? (float)$_POST['cmv'] : 0;
    $custosOperacionais   = isset($_POST['custos_operacionais']) ? (float)$_POST['custos_operacionais'] : 0;
    $custosFixosPlataforma= isset($_POST['custos_fixos_plataforma']) ? (float)$_POST['custos_fixos_plataforma'] : 0;
    $comissaoGestao       = isset($_POST['comissao_gestao']) ? (float)$_POST['comissao_gestao'] : 0;
    $comissaoPlataforma   = isset($_POST['comissao_plataforma']) ? (float)$_POST['comissao_plataforma'] : 0;
    $lucroDesejado        = isset($_POST['lucro_desejado']) ? (float)$_POST['lucro_desejado'] : 0;
    $fat12m               = isset($_POST['fat_12m']) ? (float)$_POST['fat_12m'] : 0;
    $regimeTributario     = isset($_POST['regime_tributario']) ? trim((string)$_POST['regime_tributario']) : '';
    $plataformaSlug       = isset($_POST['plataforma_slug']) ? trim((string)$_POST['plataforma_slug']) : '';

    $precoCusto           = isset($_POST['preco_custo']) ? (float)$_POST['preco_custo'] : 0;
    $precoVenda           = isset($_POST['preco_venda']) ? (float)$_POST['preco_venda'] : 0;
    $lucroValor           = isset($_POST['lucro_valor']) ? (float)$_POST['lucro_valor'] : 0;
    $lucroPercent         = isset($_POST['lucro_percent']) ? (float)$_POST['lucro_percent'] : 0;
    $impostosPercent      = isset($_POST['impostos_percent']) ? (float)$_POST['impostos_percent'] : 0;
    $ctv                  = isset($_POST['ctv']) ? (float)$_POST['ctv'] : 0;
    $markup               = isset($_POST['markup']) ? (float)$_POST['markup'] : 0;

    $sql = "INSERT INTO simulacoes (
                user_email,
                criado_em,
                plataforma_slug,
                regime_tributario,
                cmv,
                custos_operacionais,
                custos_fixos_plataforma,
                comissao_gestao,
                comissao_plataforma,
                lucro_desejado,
                fat_12m,
                preco_custo,
                preco_venda,
                lucro_valor,
                lucro_percent,
                impostos_percent,
                ctv,
                markup
            ) VALUES (
                :user_email,
                NOW(),
                :plataforma_slug,
                :regime_tributario,
                :cmv,
                :custos_operacionais,
                :custos_fixos_plataforma,
                :comissao_gestao,
                :comissao_plataforma,
                :lucro_desejado,
                :fat_12m,
                :preco_custo,
                :preco_venda,
                :lucro_valor,
                :lucro_percent,
                :impostos_percent,
                :ctv,
                :markup
            )";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':user_email'             => $usuarioEmail,
        ':plataforma_slug'        => $plataformaSlug !== '' ? $plataformaSlug : null,
        ':regime_tributario'      => $regimeTributario !== '' ? $regimeTributario : null,
        ':cmv'                    => $cmv,
        ':custos_operacionais'    => $custosOperacionais,
        ':custos_fixos_plataforma'=> $custosFixosPlataforma,
        ':comissao_gestao'        => $comissaoGestao,
        ':comissao_plataforma'    => $comissaoPlataforma,
        ':lucro_desejado'         => $lucroDesejado,
        ':fat_12m'                => $fat12m,
        ':preco_custo'            => $precoCusto,
        ':preco_venda'            => $precoVenda,
        ':lucro_valor'            => $lucroValor,
        ':lucro_percent'          => $lucroPercent,
        ':impostos_percent'       => $impostosPercent,
        ':ctv'                    => $ctv,
        ':markup'                 => $markup,
    ]);

    echo json_encode(['ok' => true]);
    exit;

} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode(['ok' => false, 'msg' => 'Erro ao salvar simulação.']);
    exit;
}
