<?php
require __DIR__ . '/db.php';
require __DIR__ . '/functions.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

header('Content-Type: application/json; charset=utf-8');

// ajuste esse índice conforme o que você usa no login
$usuarioEmail = $_SESSION['usuario_email'] ?? null;

if (!$usuarioEmail) {
    http_response_code(401);
    echo json_encode(['ok' => false, 'msg' => 'Usuário não autenticado.']);
    exit;
}

try {
    // Valores chegam do JS possivelmente com vírgula em vez de ponto
    $cmv                 = str_replace(',', '.', $_POST['cmv'] ?? '0');
    $despesas_fixas      = str_replace(',', '.', $_POST['despesas_fixas'] ?? '0');
    $taxa_mentoria       = str_replace(',', '.', $_POST['taxa_mentoria'] ?? '0');
    $custo_fixo_plat     = str_replace(',', '.', $_POST['custo_fixo_plataforma'] ?? '0');
    $taxa_plataforma     = str_replace(',', '.', $_POST['taxa_plataforma'] ?? '0');
    $fat_12m             = str_replace(',', '.', $_POST['fat_12m'] ?? '0');
    $lucro_desejado      = str_replace(',', '.', $_POST['lucro_desejado'] ?? '0');

    // Dados ANTES (para log)
    $antesRow = null;
    $stmtAntes = $pdo->prepare("SELECT
                                    cmv,
                                    despesas_fixas,
                                    taxa_mentoria,
                                    custo_fixo_plataforma,
                                    taxa_plataforma,
                                    fat_12m,
                                    lucro_desejado
                                 FROM user_defaults
                                 WHERE user_email = :email
                                 LIMIT 1");
    $stmtAntes->execute([':email' => $usuarioEmail]);
    $rowAntes = $stmtAntes->fetch(PDO::FETCH_ASSOC);
    if ($rowAntes) {
        $antesRow = array_map('floatval', $rowAntes);
    }

    $dados = [
        'cmv'                   => $cmv,
        'despesas_fixas'        => $despesas_fixas,
        'taxa_mentoria'         => $taxa_mentoria,
        'custo_fixo_plataforma' => $custo_fixo_plat,
        'taxa_plataforma'       => $taxa_plataforma,
        'fat_12m'               => $fat_12m,
        'lucro_desejado'        => $lucro_desejado,
    ];

    salvar_user_defaults($pdo, $usuarioEmail, $dados);

    // Dados DEPOIS (para log)
    $stmtDepois = $pdo->prepare("SELECT
                                    cmv,
                                    despesas_fixas,
                                    taxa_mentoria,
                                    custo_fixo_plataforma,
                                    taxa_plataforma,
                                    fat_12m,
                                    lucro_desejado
                                 FROM user_defaults
                                 WHERE user_email = :email
                                 LIMIT 1");
    $stmtDepois->execute([':email' => $usuarioEmail]);
    $rowDepois = $stmtDepois->fetch(PDO::FETCH_ASSOC);
    $depoisRow = $rowDepois ? array_map('floatval', $rowDepois) : null;

    // Determina ação: create ou update
    $acao = $antesRow ? 'update' : 'create';

    registrar_log_auditoria(
        $pdo,
        'usuario',
        $usuarioEmail,
        'defaults',
        $usuarioEmail,
        $acao,
        'defaults',
        $antesRow,
        $depoisRow
    );

    echo json_encode(['ok' => true]);
    exit;

} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['ok' => false, 'msg' => $e->getMessage()]);
    exit;
}
