<?php
// index.php

require __DIR__ . '/db.php';
require __DIR__ . '/functions.php';

$TRIAL_MAX_SIMULACOES = (int) get_app_setting($pdo, 'trial_max_simulacoes', '3');
$TRIAL_MAX_DIAS       = (int) get_app_setting($pdo, 'trial_max_dias', '7');
if ($TRIAL_MAX_SIMULACOES <= 0) {
  $TRIAL_MAX_SIMULACOES = 3;
}
if ($TRIAL_MAX_DIAS <= 0) {
  $TRIAL_MAX_DIAS = 7;
}

if (session_status() === PHP_SESSION_NONE) {
  session_start();
}

$usuarioEmail = $_SESSION['usuario_email'] ?? null;
if (!$usuarioEmail) {
    header('Location: login.php');
    exit;
}

// Valores padrão globais quando usuário ainda não tem preferências salvas
$DEFAULTS = [
  'cmv' => '0,00',
  'despesas_fixas' => '0,00',
  'taxa_mentoria' => '0,00',
  'custo_fixo_plataforma' => '0,00',
  'taxa_plataforma' => '0,00',
  'fat_12m' => '0,00',
  'lucro_desejado' => '0,00',
];


$PLATAFORMAS = load_plataformas($pdo, $usuarioEmail);
$DEFAULTS = get_user_defaults($pdo, $usuarioEmail, $DEFAULTS);

if (empty($_SESSION['usuario_autorizado'])) {
  header('Location: login.php');
  exit;
}

$trialAtivo = !empty($_SESSION['usuario_trial']);
$trialRestantes = isset($_SESSION['trial_restantes']) ? (int)$_SESSION['trial_restantes'] : $TRIAL_MAX_SIMULACOES;

$pageTitle = get_app_setting($pdo, 'app_name', 'Formação de Preço de Venda');

include __DIR__ . '/header.php';
?>

<div class="grid">
  <div class="card">
    <div class="card-header">
      <div class="card-title">Etapa 1 · Entradas principais (custos)</div>
      <span class="badge">CUSTOS</span>
    </div>

    <div class="field">
      <label>
        C1 · Custo do produto (CMV)
        <span class="code">obrigatório</span>
      </label>
      <input
        id="cmv"
        type="text"
        inputmode="decimal"
        placeholder="Ex: 38,00"
        value="<?php echo htmlspecialchars($DEFAULTS['cmv']); ?>"
      >
      <div class="hint">
        Informe quanto você pagou pelo produto (custo direto). Exemplo: custo de compra, fábrica ou fornecedor.
      </div>
    </div>

    <div class="field">
      <label>
        C2 · Custos operacionais (R$)
      </label>
      <input
        id="custos_operacionais"
        type="text"
        inputmode="decimal"
        placeholder="Ex: 5,00"
        value="<?php echo htmlspecialchars($DEFAULTS['despesas_fixas']); ?>"
      >
      <div class="hint">
        Some aqui custos como embalagem, etiquetas, frete interno, mão de obra operacional unitária, etc.
      </div>
    </div>

    <div class="field">
      <label>
        C3 · Comissão Gestão (%)
      </label>
      <input
        id="comissao_gestao"
        type="number"
        step="0.01"
        placeholder="Ex: 5"
        value="<?php echo htmlspecialchars($DEFAULTS['taxa_mentoria']); ?>"
      >
      <div class="hint">
        Percentual de comissão ou taxa de gestão sobre a venda (mentoria, gestor de tráfego, etc).
      </div>
    </div>

    <div class="field">
      <label>
        C4 · Custos Fixos Plataforma (R$)
      </label>
      <input
        id="custos_fixos_plataforma"
        type="text"
        inputmode="decimal"
        placeholder="Ex: 2,00"
        value="<?php echo htmlspecialchars($DEFAULTS['custo_fixo_plataforma']); ?>"
        readonly
      >
      <div class="hint">
        Custo fixo da plataforma por pedido/venda. Este valor é preenchido automaticamente ao escolher a plataforma.
      </div>
    </div>

    <div class="field">
      <label>
        C5 · Comissão Plataforma (%)
      </label>
      <input
        id="comissao_plataforma"
        type="number"
        step="0.01"
        placeholder="Ex: 18"
        value="<?php echo htmlspecialchars($DEFAULTS['taxa_plataforma']); ?>"
        readonly
      >
      <div class="hint">
        Percentual de comissão cobrada pela plataforma sobre o valor da venda.
      </div>
    </div>

    <hr class="divider">

    <div class="field">
      <label>
        C6 · Faturamento 12 meses (Simples Nacional)
      </label>
      <input
        id="fat_12m"
        type="text"
        inputmode="decimal"
        placeholder="Ex: 242.000,00"
        value="<?php echo htmlspecialchars($DEFAULTS['fat_12m']); ?>"
      >
      <div class="hint">
        Valor do faturamento bruto acumulado nos últimos 12 meses, para cálculo da alíquota efetiva do Simples Nacional.
      </div>
    </div>

    <div class="field">
      <label>
        Regime tributário
      </label>
      <select id="regime_tributario">
        <option value="simples">Simples Nacional</option>
        <option value="lucro_presumido">Lucro Presumido</option>
        <option value="lucro_real">Lucro Real</option>
      </select>
      <div class="hint">
        Selecione o regime adotado hoje para esta empresa. Os percentuais de imposto serão calculados automaticamente.
      </div>
    </div>

    <div class="field" id="grupo_simples_maturidade">
      <label>
        Situação da empresa no Simples Nacional
      </label>
      <select id="simples_maturidade">
        <option value="mais_12">Empresa com mais de 12 meses de atividade</option>
        <option value="menos_12">Empresa com menos de 12 meses de atividade</option>
      </select>
    </div>

    <div class="field" id="grupo_meses_atividade" style="display:none;">
      <label>
        Meses de atividade (empresa com menos de 12 meses)
      </label>
      <input
        id="meses_atividade"
        type="number"
        min="1"
        max="12"
        placeholder="Ex: 6"
        value="12"
      >
      <div class="hint">
        Usado para projetar o faturamento dos 12 meses (RBT12) quando a empresa tem menos de 12 meses de operação.
      </div>
    </div>

    <hr class="divider">

    <div class="field">
      <label>
        C8 · Lucro desejado (%)
      </label>
      <input
        id="lucro_desejado"
        type="number"
        step="0.01"
        placeholder="Ex: 20"
        value="<?php echo htmlspecialchars($DEFAULTS['lucro_desejado']); ?>"
      >
      <div class="hint">
        Percentual de lucro líquido desejado sobre o valor de venda.
      </div>
    </div>

    <div class="footer-note">
      Ao ajustar qualquer campo, pressione <b>Enter</b> para recalcular ou altere de campo para atualizar os resultados.
    </div>
  </div>

  <div class="card">
    <div class="card-header">
      <div class="card-title">Etapa 2 · Plataforma e impostos</div>
      <span class="badge">PLATAFORMA</span>
    </div>

    <div class="field">
      <label>
        Plataforma de venda
      </label>
      <select id="select_plataforma" onchange="onPlataformaChange()">
        <option value="">Selecione...</option>
        <?php foreach ($PLATAFORMAS as $slug => $p): ?>
          <option value="<?php echo htmlspecialchars($slug); ?>">
            <?php echo htmlspecialchars($p['nome']); ?>
          </option>
        <?php endforeach; ?>
      </select>

      <div class="hint">
        A taxa (%) e o custo fixo em R$ serão aplicados automaticamente com base na plataforma escolhida.
      </div>
    </div>
	
	 <div class="field" style="margin-top:6px;">
		<button type="button" class="btn" onclick="salvarPadroesUsuario()">
		  Salvar como padrão
		</button>
	</div>

    <div class="field">
      <label>
        Plataforma ativa
      </label>
      <div class="pill">
        <span class="dot"></span>
        <span id="plataforma_nome">—</span>
      </div>
      <div class="hint">
        Ao selecionar uma plataforma, os campos bloqueados de comissão e custo fixo são atualizados com seus parâmetros padrão.
      </div>
    </div>

    <hr class="divider">

    <div class="field">
      <label>Cadastro / edição de plataforma</label>
      <div class="hint">
        Adicione novas plataformas ou ajuste taxas de plataformas existentes.
      </div>
    </div>

    <div class="field">
      <label>Nome da plataforma</label>
      <input
        id="nova_plataforma_nome"
        type="text"
        placeholder="Ex: Minha Plataforma X"
      >
    </div>

    <div class="field-row">
      <div class="field">
        <label>Taxa da plataforma (%)</label>
        <input
          id="nova_plataforma_taxa"
          type="number"
          step="0.01"
          placeholder="Ex: 15"
        >
      </div>
      <div class="field">
        <label>Custo fixo por venda (R$)</label>
        <input
          id="nova_plataforma_custo_fixo"
          type="text"
          inputmode="decimal"
          placeholder="Ex: 2,00"
        >
      </div>
    </div>

    <div class="field-row" style="margin-top:8px;">
      <div class="field">
        <button
          type="button"
          id="btn_salvar_plataforma"
          class="btn"
          style="width:100%;justify-content:center;"
          onclick="addNovaPlataforma()"
        >
          <span class="dot"></span> Adicionar plataforma
        </button>
      </div>
      <div class="field">
        <button
          type="button"
          class="btn"
          style="width:100%;justify-content:center;background:transparent;border-color:#f97373;color:#fecaca;box-shadow:none;"
          onclick="iniciarEdicaoPlataforma()"
        >
          Editar plataforma selecionada
        </button>
      </div>
    </div>

    <div class="field" style="margin-top:6px;">
      <button
        type="button"
        class="btn"
        style="width:100%;justify-content:center;background:transparent;border-color:#b91c1c;color:#fecaca;box-shadow:none;"
        onclick="excluirPlataformaAtual()"
      >
        Excluir plataforma selecionada
      </button>
    </div>
	
    <hr class="divider">

    <div class="field">
      <label>Resumo do imposto (RBT12 / Simples / outros regimes)</label>
      <div class="hint">
        Estes valores são estimativas com base na legislação atual para comércio. Sempre valide com seu contador.
      </div>
    </div>

    <div class="result-grid">
      <div class="metric">
        <div class="metric-label">
          <span>Alíquota efetiva do imposto</span>
        </div>
        <div class="metric-value" id="out_imposto_real">0,00%</div>
      </div>
      <div class="metric">
        <div class="metric-label">
          <span>Alíquota nominal (Simples)</span>
        </div>
        <div class="metric-value" id="out_aliquota">0,00%</div>
      </div>
      <div class="metric">
        <div class="metric-label">
          <span>Dedução (Simples)</span>
        </div>
        <div class="metric-value" id="out_deducao">R$ 0,00</div>
      </div>
      <div class="metric">
        <div class="metric-label">
          <span>Imposto estimado (12 meses)</span>
        </div>
        <div class="metric-value" id="out_imposto_estimado">R$ 0,00</div>
      </div>
    </div>
  </div>

  <div class="card">
    <div class="card-header">
      <div class="card-title">Etapa 3 · Resultado e simulação reversa</div>
      <?php if ($trialAtivo): ?>
        <span class="badge" id="trial_badge">
          Trial: <?php echo max(0, (int)$trialRestantes); ?> simulações restantes
        </span>
      <?php else: ?>
        <span class="badge">RESULTADO</span>
      <?php endif; ?>
    </div>
	
	<div class="modal-container">
		<div class="mode-tabs" >
		  <button
			type="button"
			id="btn_modo_direto"
			class="mode-tab-btn active"
			onclick="setModoResultado('direto')">
			Cálculo direto
		  </button>
		  <button
			type="button"
			id="btn_modo_reverso"
			class="mode-tab-btn"
			onclick="setModoResultado('reverso')">
			Cálculo reverso
		  </button>
		  <button 
			type="button" 
			class="btn-red" 
			onclick="recalcularTudo();">
			Calcular
		  </button>
		</div>	
    </div>
	
	<div class="hint">
		Clique em "Calcular" para atualizar os resultados. No modo Trial, cada clique conta como uma simulação.
	</div>

    <div id="modo_direto" style="display:block;margin-top:6px;">
      <div class="field">
        <label>Resumo principal</label>
      </div>

      <div class="result-grid">
        <div class="metric metric-highlight">
          <div class="metric-label">
            <span>Preço de venda sugerido</span>
          </div>
          <div class="metric-value" id="out_preco_venda">R$ 0,00</div>
        </div>

        <div class="metric">
          <div class="metric-label">
            <span>Lucro líquido estimado</span>
          </div>
          <div class="metric-value" id="out_lucro">R$ 0,00</div>
        </div>

        <div class="metric">
          <div class="metric-label">
            <span>Custo total do produto</span>
          </div>
          <div class="metric-value" id="out_preco_custo">R$ 0,00</div>
        </div>

        <div class="metric">
          <div class="metric-label">
            <span>CTv total (gestão + plataforma + impostos + lucro)</span>
          </div>
          <div class="metric-value" id="out_ctv">0,00%</div>
        </div>

        <div class="metric hidden-metric">
          <div class="metric-label">
            <span>Markup de venda</span>
          </div>
          <div class="metric-value" id="out_markup">0,00%</div>
        </div>
      </div>

      <div
        id="metric_alert"
        class="metric metric-danger"
        style="margin-top:10px;display:none;"
      >
        <div class="metric-label">
          <span>Atenção</span>
        </div>
        <div class="metric-value metric-small">
          A soma das taxas (gestão + plataforma + impostos + lucro desejado) está igual ou acima de 100%.<br>
          Ajuste os percentuais para que o cálculo seja possível.
        </div>
      </div>
    </div>

    <div id="modo_reverso" style="display:none;margin-top:6px;">
      <div class="field">
        <label>Preço de venda desejado</label>
        <input
          id="pv_reverso"
          type="text"
          inputmode="decimal"
          placeholder="Ex: 99,90"
          value=""
        >
        <div class="hint">
          Informe o valor de venda que você pretende praticar. O sistema calcula o lucro real com as taxas atuais.
        </div>
      </div>

      <div class="result-grid">
        <div class="metric metric-highlight">
          <div class="metric-label">
            <span>Lucro estimado neste preço</span>
          </div>
          <div class="metric-value" id="out_lucro_rev">R$ 0,00</div>
        </div>

        <div class="metric">
          <div class="metric-label">
            <span>Lucro em relação ao preço de venda</span>
          </div>
          <div class="metric-value" id="out_lucro_percent_rev">0,00%</div>
        </div>

        <div class="metric">
          <div class="metric-label">
            <span>Custo total do produto</span>
          </div>
          <div class="metric-value" id="out_preco_custo_rev">R$ 0,00</div>
        </div>

        <div class="metric">
          <div class="metric-label">
            <span>Taxas totais (gestão + plataforma + impostos)</span>
          </div>
          <div class="metric-value" id="out_taxas_totais_rev">R$ 0,00</div>
        </div>
      </div>
    </div>

    <div class="footer-note">
      Use o <b>Cálculo direto</b> para descobrir o preço ideal a partir dos custos e taxas.<br>
      Use o <b>Cálculo reverso</b> para testar preços de venda específicos e ver qual lucro seria alcançado.
    </div>
  </div>
</div>

<?php include __DIR__ . '/footer.php'; ?>