-- Tabela para histórico de simulações dos usuários
CREATE TABLE IF NOT EXISTS simulacoes (
  id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
  user_email VARCHAR(190) NOT NULL,
  criado_em DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  plataforma_slug VARCHAR(100) DEFAULT NULL,
  regime_tributario VARCHAR(50) DEFAULT NULL,
  cmv DECIMAL(14,2) DEFAULT 0,
  custos_operacionais DECIMAL(14,2) DEFAULT 0,
  custos_fixos_plataforma DECIMAL(14,2) DEFAULT 0,
  comissao_gestao DECIMAL(8,4) DEFAULT 0,
  comissao_plataforma DECIMAL(8,4) DEFAULT 0,
  lucro_desejado DECIMAL(8,4) DEFAULT 0,
  fat_12m DECIMAL(18,2) DEFAULT 0,
  preco_custo DECIMAL(14,2) DEFAULT 0,
  preco_venda DECIMAL(14,2) DEFAULT 0,
  lucro_valor DECIMAL(14,2) DEFAULT 0,
  lucro_percent DECIMAL(8,4) DEFAULT 0,
  impostos_percent DECIMAL(8,4) DEFAULT 0,
  ctv DECIMAL(8,4) DEFAULT 0,
  markup DECIMAL(8,4) DEFAULT 0,
  KEY idx_sim_user (user_email),
  KEY idx_sim_data (criado_em)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Tabela para logs de auditoria (plataformas e padrões)
CREATE TABLE IF NOT EXISTS logs_auditoria (
  id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
  criado_em DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  actor_tipo VARCHAR(20) NOT NULL,
  actor_email VARCHAR(190) DEFAULT NULL,
  alvo_tipo VARCHAR(30) NOT NULL,
  alvo_user_email VARCHAR(190) DEFAULT NULL,
  acao VARCHAR(20) NOT NULL,
  referencia VARCHAR(190) DEFAULT NULL,
  dados_antes TEXT DEFAULT NULL,
  dados_depois TEXT DEFAULT NULL,
  KEY idx_logs_data (criado_em),
  KEY idx_logs_alvo (alvo_tipo, alvo_user_email)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
