<?php
// cadastro.php
$pageTitle = 'Cadastro - Formação de Preço';
include __DIR__ . '/header.php';

$nomeParam  = isset($_GET['nome']) ? $_GET['nome'] : '';
$emailParam = isset($_GET['email']) ? $_GET['email'] : '';
?>

<div class="grid">
  <div class="card" style="max-width:680px;margin:0 auto;">
    <div class="card-header">
      <div class="card-title">Cadastro de usuário</div>
      <span class="badge">LICENÇA COMPLETA</span>
    </div>

    <div class="field">
      <label>Nome completo</label>
      <input
        id="cad_nome"
        type="text"
        placeholder="Ex: Ana Souza"
        value="<?php echo htmlspecialchars($nomeParam); ?>"
      >
    </div>

    <div class="field">
      <label>E-mail</label>
      <input
        id="cad_email"
        type="email"
        placeholder="voce@empresa.com"
        value="<?php echo htmlspecialchars($emailParam); ?>"
      >
    </div>

    <div class="field">
      <label>WhatsApp</label>
      <input
        id="cad_whatsapp"
        type="text"
        placeholder="(11) 98888-7777"
      >
      <div class="hint">
        Use um número válido, você pode enviar o acesso e suporte por aqui.
      </div>
    </div>

    <div class="field-row">
      <div class="field">
        <label>Tipo de cliente</label>
        <select id="cad_tipo_pessoa">
          <option value="pf">Pessoa física (CPF)</option>
          <option value="pj">Pessoa jurídica (CNPJ)</option>
        </select>
      </div>
      <div class="field">
        <label>CPF / CNPJ</label>
        <input
          id="cad_documento"
          type="text"
          placeholder="Somente números"
        >
      </div>
    </div>

    <div class="field-row">
      <div class="field">
        <label>Senha</label>
        <input
          id="cad_senha"
          type="password"
          placeholder="Mínimo 6 caracteres"
        >
      </div>
      <div class="field">
        <label>Confirmar senha</label>
        <input
          id="cad_senha_conf"
          type="password"
          placeholder="Repita a senha"
        >
      </div>
    </div>

    <div class="field">
      <label style="justify-content:flex-start;gap:8px;">
        <input
          id="cad_aceite"
          type="checkbox"
          style="width:auto;accent-color:#22c55e;"
        >
        <span style="font-size:0.8rem;color:#9ca3af;">
          Li e aceito os termos de uso e política de privacidade.
        </span>
      </label>
      <div class="hint">
        Aqui você pode depois apontar para uma página com seus termos completos.
      </div>
    </div>

    <hr class="divider">

    <div class="field">
      <button
        type="button"
        class="btn"
        style="width:100%;justify-content:center;font-size:0.9rem;"
        onclick="enviarCadastro()"
      >
        <span class="dot"></span> Cadastrar e ir para pagamento
      </button>
      <div class="hint" id="cad_feedback" style="margin-top:6px;"></div>
    </div>

    <div class="field" style="margin-top:10px;">
      <div class="hint">
        Só quer testar por enquanto?  
        <a href="trial.php" style="color:#a5b4fc;text-decoration:none;">
          Acesse a versão Trial (3 simulações grátis)
        </a>
      </div>
    </div>
  </div>
</div>

<script>
  function enviarCadastro() {
    const nome        = document.getElementById('cad_nome').value.trim();
    const email       = document.getElementById('cad_email').value.trim();
    const whatsapp    = document.getElementById('cad_whatsapp').value.trim();
    const tipoPessoa  = document.getElementById('cad_tipo_pessoa').value;
    const documento   = document.getElementById('cad_documento').value.trim();
    const senha       = document.getElementById('cad_senha').value;
    const senhaConf   = document.getElementById('cad_senha_conf').value;
    const aceite      = document.getElementById('cad_aceite').checked;
    const feedbackEl  = document.getElementById('cad_feedback');

    function setFeedback(msg, ok) {
      feedbackEl.textContent = msg;
      feedbackEl.style.color = ok ? '#22c55e' : '#f97373';
    }

    if (!nome || !email || !whatsapp || !documento || !senha || !senhaConf) {
      setFeedback('Preencha todos os campos obrigatórios.', false);
      return;
    }

    if (senha.length < 6) {
      setFeedback('A senha deve ter pelo menos 6 caracteres.', false);
      return;
    }

    if (senha !== senhaConf) {
      setFeedback('As senhas não conferem.', false);
      return;
    }

    if (!aceite) {
      setFeedback('Você precisa aceitar os termos para continuar.', false);
      return;
    }

    setFeedback('Cadastro validado. Redirecionando para pagamento...', true);

    const params = new URLSearchParams({
      nome: nome,
      email: email,
      whatsapp: whatsapp,
      tipo: tipoPessoa,
      doc: documento
    });

    setTimeout(() => {
      window.location.href = 'pagamento.php?' + params.toString();
    }, 800);
  }
</script>

<?php include __DIR__ . '/footer.php'; ?>
